package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: UserReadingStatus.java , v 0.1 2019-09-19 11:29 ElinZhou Exp $
 */
public enum UserReadingStatus {
    //任务状态 1：进行中 2：失败 3：成功待发奖 4：成功已发奖',

    IN_PROGRESS(1),

    FAILURE(2),

    SUCCESS_WAIT_AWARD(3),

    SUCCESS(4),

    ;

    private int code;

    private static final Map<Integer, UserReadingStatus> CACHE =
            Arrays.stream(UserReadingStatus.values()).collect(Collectors.toMap(UserReadingStatus::getCode, u -> u));

    public static UserReadingStatus of(int code) {
        return CACHE.get(code);
    }

    UserReadingStatus(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }}
