package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.WithdrawDto;
import cn.tuia.explore.center.api.dto.req.WithdrawQueryDto;
import cn.tuia.explore.center.api.dto.rsp.PageQueryResultDto;
import cn.tuia.explore.center.api.dto.rsp.WithdrawOrderDto;
import cn.tuia.explore.center.api.dto.rsp.WithdrawRateDto;
import cn.tuia.explore.center.api.dto.rsp.WithdrawRecordDto;

import java.util.List;
import java.util.Map;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: RemoteWithdrawService.java , v 0.1 2019-09-16 13:41 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteWithdrawService {

    /**
     * 申请提现
     *
     * @param withdrawDto
     * @return
     * @throws BizException
     */
    WithdrawOrderDto apply(WithdrawDto withdrawDto) throws BizException;

    /**
     * 查询汇率
     *
     * @return
     */
    WithdrawRateDto queryRate();


    /**
     * 查询提现订单（包括详细状态）
     *
     * @param serialNumber
     * @return
     */
    WithdrawOrderDto queryComplexOrder(long serialNumber) throws BizException;

    /**
     * 列表查询
     *
     * @param queryDto
     * @return
     */
    PageQueryResultDto<WithdrawRecordDto> pageQuery(WithdrawQueryDto queryDto);


    /**
     * 批量通过审核
     *
     * @param serialNumbers
     */
    void pass(List<Long> serialNumbers);

    /**
     * 批量拒绝审核
     *
     * @param serialNumberAndResons
     */
    void reject(Map<Long, String> serialNumberAndResons);

    /**
     * 批量驳回审核
     *
     * @param serialNumberAndResons
     */
    void refund(Map<Long, String> serialNumberAndResons);

}
