/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.dto.qcc.ggk;

import cn.tuia.explore.center.api.dto.qcc.ggk.enums.ScratchBagType;
import cn.tuia.explore.center.api.dto.qcc.ggk.enums.ScratchPriceType;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ScratchCardBag
implements Serializable {
    private static final String DEFAULT_TITLE = "\u7a00\u6709\u5361\u7247";
    private static final String DEFAULT_INNER_TITLE = "\u522e\u5230\u591a\u5c11\u5956\u52b1\u591a\u5c11";
    private static final Integer DEFAULT_CARD_COUNT = 6;
    private Long userId;
    private String title;
    private String innerTitle;
    private Integer cardCount;
    private Integer scratchedCount;
    private ScratchBagType bagType;
    private List<ScratchCard> scratchCards;
    private int bagIndex;
    private Date scratchTime;
    private Long moneyTotal;
    private Long goleTotal;

    private static List<ScratchCard> initScratchCards(int cardCount) {
        ArrayList scratchCards = Lists.newArrayListWithCapacity((int)cardCount);
        for (int i = 0; i < cardCount; ++i) {
            scratchCards.add(new ScratchCard(i));
        }
        return scratchCards;
    }

    public ScratchCardBag() {
    }

    public ScratchCardBag(Long userId, ScratchBagType bagType, int bagIndex) {
        this(userId, DEFAULT_TITLE, DEFAULT_INNER_TITLE, DEFAULT_CARD_COUNT, 0, bagType, ScratchCardBag.initScratchCards(DEFAULT_CARD_COUNT), bagIndex);
    }

    public ScratchCardBag(Long userId, String title, String innerTitle, Integer cardCount, Integer scratchedCount, ScratchBagType bagType, List<ScratchCard> scratchCards, int bagIndex) {
        this.userId = userId;
        this.title = title;
        this.innerTitle = innerTitle;
        this.cardCount = cardCount;
        this.scratchedCount = scratchedCount;
        this.bagType = bagType;
        this.scratchCards = scratchCards;
        this.bagIndex = bagIndex;
        this.goleTotal = 0L;
        this.moneyTotal = 0L;
    }

    public int getBagIndex() {
        return this.bagIndex;
    }

    public void setBagIndex(int bagIndex) {
        this.bagIndex = bagIndex;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInnerTitle() {
        return this.innerTitle;
    }

    public void setInnerTitle(String innerTitle) {
        this.innerTitle = innerTitle;
    }

    public Integer getCardCount() {
        return this.cardCount;
    }

    public void setCardCount(Integer cardCount) {
        this.cardCount = cardCount;
    }

    public Integer getScratchedCount() {
        return this.scratchedCount;
    }

    public void setScratchedCount(Integer scratchedCount) {
        this.scratchedCount = scratchedCount;
    }

    public ScratchBagType getBagType() {
        return this.bagType;
    }

    public void setBagType(ScratchBagType bagType) {
        this.bagType = bagType;
    }

    public List<ScratchCard> getScratchCards() {
        return this.scratchCards;
    }

    public void setScratchCards(List<ScratchCard> scratchCards) {
        this.scratchCards = scratchCards;
    }

    public Date getScratchTime() {
        return this.scratchTime;
    }

    public void setScratchTime(Date scratchTime) {
        this.scratchTime = scratchTime;
    }

    public Long getMoneyTotal() {
        return this.moneyTotal;
    }

    public void setMoneyTotal(Long moneyTotal) {
        this.moneyTotal = moneyTotal;
    }

    public Long getGoleTotal() {
        return this.goleTotal;
    }

    public void setGoleTotal(Long goleTotal) {
        this.goleTotal = goleTotal;
    }

    public static class ScratchCardPrize
    implements Serializable {
        private ScratchPriceType priceType;
        private Long priceAmount;

        public ScratchPriceType getPriceType() {
            return this.priceType;
        }

        public void setPriceType(ScratchPriceType priceType) {
            this.priceType = priceType;
        }

        public Long getPriceAmount() {
            return this.priceAmount;
        }

        public void setPriceAmount(Long priceAmount) {
            this.priceAmount = priceAmount;
        }
    }

    public static class ScratchCard
    implements Serializable {
        private Integer index;
        private String title;
        private Integer status;
        private ScratchCardPrize prize;

        public ScratchCard() {
        }

        public ScratchCard(Integer index) {
            this(index, "", 0, null);
        }

        public ScratchCard(Integer index, String title, Integer status, ScratchCardPrize prize) {
            this.index = index;
            this.title = title;
            this.status = status;
            this.prize = prize;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public ScratchCardPrize getPrize() {
            return this.prize;
        }

        public void setPrize(ScratchCardPrize prize) {
            this.prize = prize;
        }
    }
}

