/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.dto.qcc.ggk.enums;

import cn.tuia.explore.center.api.dto.qcc.ggk.ScratchCardBag;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public enum ScratchBagType {
    R(0, "R", "", Lists.newArrayList()),
    N(1, "N", "", Lists.newArrayList()),
    SR(2, "SR", "", Lists.newArrayList()),
    SSR(3, "SSR", "", Lists.newArrayList());

    private int code;
    private String title;
    private String desc;
    private List<PriceSet> pricePool;

    private ScratchBagType(int code, String title, String desc, List<PriceSet> pricePool) {
        this.code = code;
        this.title = title;
        this.desc = desc;
        this.pricePool = pricePool;
    }

    public static ScratchBagType getByCode(int code) {
        for (ScratchBagType type : ScratchBagType.values()) {
            if (type.code != code) continue;
            return type;
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public PriceSet randomPrice() {
        Iterator<PriceSet> iterator = this.pricePool.iterator();
        while (iterator.hasNext()) {
            Random random = new Random();
            PriceSet p = iterator.next();
            if (random.nextInt(p.getDenominator()) >= p.numerator) continue;
            return p;
        }
        return null;
    }

    public class PriceSet {
        private ScratchCardBag.ScratchCardPrize prize;
        private int numerator;
        private int denominator;

        public PriceSet(ScratchCardBag.ScratchCardPrize prize, int numerator, int denominator) {
            this.prize = prize;
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public ScratchCardBag.ScratchCardPrize getPrize() {
            return this.prize;
        }

        public void setPrize(ScratchCardBag.ScratchCardPrize prize) {
            this.prize = prize;
        }

        public int getNumerator() {
            return this.numerator;
        }

        public void setNumerator(int numerator) {
            this.numerator = numerator;
        }

        public int getDenominator() {
            return this.denominator;
        }

        public void setDenominator(int denominator) {
            this.denominator = denominator;
        }
    }
}

