/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import cn.tuia.explore.center.api.enums.CoinTradeCode;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum CoinExpense implements CoinTradeCode
{
    UNKNOW(0, "\u672a\u77e5\u652f\u51fa"),
    WITHDRAW(1, "\u7533\u8bf7\u63d0\u73b0");

    private int bizCode;
    private String desc;
    private static final Map<Integer, CoinExpense> CACHE;

    private CoinExpense(int bizCode, String desc) {
        this.bizCode = bizCode;
        this.desc = desc;
    }

    public static CoinExpense of(int bizCode) {
        CoinExpense coinExpense = CACHE.get(bizCode);
        if (coinExpense != null) {
            return coinExpense;
        }
        return UNKNOW;
    }

    @Override
    public int bizCode() {
        return this.bizCode;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    static {
        CACHE = Arrays.stream(CoinExpense.values()).collect(Collectors.toMap(CoinExpense::bizCode, c -> c));
    }
}

