/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import cn.tuia.explore.center.api.enums.CoinTradeCode;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum CoinIncome implements CoinTradeCode
{
    UNKNOW(0, "\u672a\u77e5\u6536\u5165"),
    WITHDRAW_REFUND(1, "\u63d0\u73b0\u9a73\u56de"),
    READ_TASK_REWARD(2, "\u9605\u8bfb\u517b\u6210\u73ed\u74dc\u5206\u5956\u52b1"),
    DAILY_MISSION(3, "\u5b8c\u6210\u65e5\u5e38\u4efb\u52a1"),
    SCRATCH_CARD_REWARD(4, "\u522e\u522e\u5361\u91d1\u5e01\u5956\u52b1");

    private int bizCode;
    private String desc;
    private static final Map<Integer, CoinIncome> CACHE;

    private CoinIncome(int bizCode, String desc) {
        this.bizCode = bizCode;
        this.desc = desc;
    }

    public static CoinIncome of(int bizCode) {
        CoinIncome coinIncome = CACHE.get(bizCode);
        if (coinIncome != null) {
            return coinIncome;
        }
        return UNKNOW;
    }

    @Override
    public int bizCode() {
        return this.bizCode;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    static {
        CACHE = Arrays.stream(CoinIncome.values()).collect(Collectors.toMap(CoinIncome::bizCode, c -> c));
    }
}

