/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum DailyLuckyRewardType {
    FIRST_PRIZE(1, 10000L),
    SECOND_PRIZE(2, 100L),
    THIRD_PRIZE(3, 10L),
    NONE(4, 0L);

    private int code;
    private long reward;
    private static final Map<Integer, DailyLuckyRewardType> CACHE;

    public long getReward() {
        return this.reward;
    }

    public int getCode() {
        return this.code;
    }

    public static DailyLuckyRewardType of(int code) {
        return CACHE.get(code);
    }

    private DailyLuckyRewardType(int code, long reward) {
        this.code = code;
        this.reward = reward;
    }

    static {
        CACHE = Arrays.stream(DailyLuckyRewardType.values()).collect(Collectors.toMap(DailyLuckyRewardType::getCode, d -> d));
    }
}

