/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum Platform {
    ANDROID(0),
    IOS(1),
    BOTH(2);

    private int code;
    private static final Map<Integer, Platform> CACHE;

    public static Platform of(int code) {
        return CACHE.get(code);
    }

    private Platform(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    static {
        CACHE = Arrays.stream(Platform.values()).collect(Collectors.toMap(Platform::getCode, p -> p));
    }
}

