/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PostFlowFetchType {
    FOLLOW_PAGE(1, true),
    RECOMMEND_PAGE(2, false),
    PERSIONAL_PAGE(3, true),
    GROUP_PAGE(4, false),
    IMAGE(5, false),
    VIDEO(6, false),
    CHANNEL(7, false),
    VIDEO_CHANNEL(8, false),
    TAG(9, false),
    SIMILAR(10, false);

    private Integer code;
    private boolean needLogin;
    private static final Map<Integer, PostFlowFetchType> CACHE;

    private PostFlowFetchType(Integer code, boolean needLogin) {
        this.code = code;
        this.needLogin = needLogin;
    }

    public boolean isNeedLogin() {
        return this.needLogin;
    }

    public Integer getCode() {
        return this.code;
    }

    public static PostFlowFetchType of(Integer code) {
        return CACHE.get(code);
    }

    static {
        CACHE = Arrays.stream(PostFlowFetchType.values()).collect(Collectors.toMap(PostFlowFetchType::getCode, p -> p));
    }
}

