/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import cn.tuia.explore.center.api.enums.PostGroup;
import cn.tuia.explore.center.api.enums.PostShowType;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PostSourceType {
    UNKNOW("\u672a\u77e5", 999, PostGroup.LINK, PostShowType.ORIGINAL_URL),
    ORIGINAL("\u539f\u521b", 0, PostGroup.LINK, PostShowType.ORIGINAL_URL),
    GONGZHONGHAO("\u516c\u4f17\u53f7", 1, PostGroup.ARTICLE, PostShowType.ORIGINAL_URL),
    KUAISHOU("\u5feb\u624b", 2, PostGroup.LINK, PostShowType.ORIGINAL_URL),
    DOUYIN("\u6296\u97f3", 3, PostGroup.LINK, PostShowType.ORIGINAL_URL),
    PIPIXIA("\u76ae\u76ae\u867e", 4, PostGroup.VIDEO, PostShowType.ORIGINAL_URL),
    MEIPIAN("\u7f8e\u7bc7", 5, PostGroup.ARTICLE, PostShowType.ORIGINAL_URL),
    TIAO_BA("\u8df3\u5427\u5e7f\u573a\u821e", 7, PostGroup.VIDEO, PostShowType.ORIGINAL_URL),
    LISHIPIN("\u68a8\u89c6\u9891", 8, PostGroup.VIDEO, PostShowType.ORIGINAL_URL),
    XIGUASHIPIN("\u897f\u74dc\u89c6\u9891", 9, PostGroup.VIDEO, PostShowType.ORIGINAL_URL),
    TOUTIAOSHEYING("\u5934\u6761\u6444\u5f71\u96c6", 10, PostGroup.IMAGE, PostShowType.ORIGINAL_URL),
    XINLANGTUPIAN("\u65b0\u6d6a\u56fe\u7247", 11, PostGroup.IMAGE, PostShowType.ORIGINAL_URL),
    SOUGOU_WEIXIN("\u516c\u4f17\u53f7", 12, PostGroup.ARTICLE, PostShowType.ORIGINAL_URL),
    TX_XINWEN_SHEHUI("\u817e\u8baf\u65b0\u95fb", 13, PostGroup.ARTICLE, PostShowType.ORIGINAL_URL),
    TX_XINWEN_NEWS_24("\u817e\u8baf\u65b0\u95fb", 14, PostGroup.ARTICLE, PostShowType.ORIGINAL_URL),
    REN_MIN_WANG("\u4eba\u6c11\u7f51", 15, PostGroup.ARTICLE, PostShowType.H5_WRAPPER);

    private static final Map<Integer, PostSourceType> CACHE;
    private String name;
    private int code;
    private PostGroup postGroup;
    private PostShowType showType;

    private PostSourceType(String name, int code, PostGroup postGroup, PostShowType showType) {
        this.name = name;
        this.code = code;
        this.postGroup = postGroup;
        this.showType = showType;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public PostGroup getPostGroup() {
        return this.postGroup;
    }

    public PostShowType getShowType() {
        return this.showType;
    }

    public static PostSourceType of(int code) {
        return CACHE.get(code);
    }

    static {
        CACHE = Arrays.stream(PostSourceType.values()).collect(Collectors.toMap(PostSourceType::getCode, p -> p));
    }
}

