/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum ReadTaskType {
    NEWBIE(1, "\u65b0\u624b\u73ed", 1, 5, 2.11, 10000L, 0.75, 0.85, Lists.newArrayList((Object[])new Integer[]{100})),
    PRIMARY(2, "\u521d\u7ea7\u73ed", 3, 15, 1.61, 5000L, 0.65, 0.75, Lists.newArrayList((Object[])new Integer[]{3, 27, 100})),
    MIDDLE(3, "\u4e2d\u7ea7\u73ed", 7, 15, 0.91, 15000L, 0.6, 0.7, Lists.newArrayList((Object[])new Integer[]{6, 13, 29, 56, 80, 92, 100})),
    SENIRO(4, "\u9ad8\u7ea7\u73ed", 21, 15, 0.21, 50000L, 0.7, 0.9, Lists.newArrayList((Object[])new Integer[]{6, 7, 8, 10, 12, 16, 21, 30, 38, 46, 59, 67, 74, 80, 85, 90, 93, 95, 97, 99, 100}));

    private int level;
    private String name;
    private int durationDays;
    private int minutes;
    private double delta;
    private long coinEachUser;
    private double successRateStart;
    private double successRateEnd;
    private List<Integer> failureRate;
    private static final Map<Integer, ReadTaskType> CACHE;

    private ReadTaskType(int level, String name, int durationDays, int minutes, double delta, long coinEachUser, double successRateStart, double successRateEnd, List<Integer> failureRate) {
        this.level = level;
        this.name = name;
        this.durationDays = durationDays;
        this.minutes = minutes;
        this.delta = delta;
        this.coinEachUser = coinEachUser;
        this.successRateStart = successRateStart;
        this.successRateEnd = successRateEnd;
        this.failureRate = failureRate;
    }

    public static ReadTaskType of(int level) {
        return CACHE.get(level);
    }

    public long getCoinEachUser() {
        return this.coinEachUser;
    }

    public double getSuccessRateStart() {
        return this.successRateStart;
    }

    public double getSuccessRateEnd() {
        return this.successRateEnd;
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public int getDurationDays() {
        return this.durationDays;
    }

    public List<Integer> getFailureRate() {
        return this.failureRate;
    }

    public double getDelta() {
        return this.delta;
    }

    public int getMinutes() {
        return this.minutes;
    }

    static {
        CACHE = Arrays.stream(ReadTaskType.values()).collect(Collectors.toMap(ReadTaskType::getLevel, r -> r));
    }
}

