/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum WithdrawStatus {
    REVIEWING(1, "\u5ba1\u6838\u4e2d", false),
    REJECT(3, "\u62d2\u7edd", false),
    REFUND(4, "\u9a73\u56de", false),
    SUCCESS_WATI_PAY(5, "\u6210\u529f\u5f85\u6253\u6b3e", false),
    SUCCESS_WAIT_RETRY(6, "\u6210\u529f\u5f85\u91cd\u8bd5", false),
    PAID(7, "\u5df2\u6253\u6b3e", true);

    private int code;
    private String desc;
    private boolean finaly;
    private static final Map<Integer, WithdrawStatus> CACHE;

    private WithdrawStatus(int code, String desc, boolean finaly) {
        this.code = code;
        this.desc = desc;
        this.finaly = finaly;
    }

    public static WithdrawStatus of(int code) {
        return CACHE.get(code);
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isFinaly() {
        return this.finaly;
    }

    static {
        CACHE = Arrays.stream(WithdrawStatus.values()).collect(Collectors.toMap(WithdrawStatus::getCode, w -> w));
    }
}

