package cn.tuia.explore.center.api.dto.general;

import cn.tuia.explore.center.api.enums.LikeType;

import java.util.Date;
import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: LikeMessage.java , v 0.1 2019-05-29 09:31 ElinZhou Exp $
 */
public class LikeMessage extends AbstractMessageContent {
    private static final long serialVersionUID = 7848168658819107139L;

    private int type;

    private long msgId;

    private int count;

    private List<Long> userList;

    private Date lastTime;

    @Override
    protected String title() {
        String title;
        if (LikeType.of(type) == LikeType.POST) {
            title = String.format("等%d个用户推荐了你的动态", count);
        } else {
            title = String.format("等%d个用户赞了你的评论", count);
        }
        return title;
    }

    @Override
    protected String content() {
        return null;
    }

    @Override
    protected String icon() {
        return null;
    }


    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getMsgId() {
        return msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public List<Long> getUserList() {
        return userList;
    }

    public void setUserList(List<Long> userList) {
        this.userList = userList;
    }

    public Date getLastTime() {
        return lastTime;
    }

    public void setLastTime(Date lastTime) {
        this.lastTime = lastTime;
    }
}
