package cn.tuia.explore.center.api.dto.qcc.ggk;

import cn.tuia.explore.center.api.dto.qcc.ggk.enums.ScratchBagType;
import cn.tuia.explore.center.api.dto.qcc.ggk.enums.ScratchPriceType;
import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: sjx
 * @date: 2019-10-17 10:36
 */
public class ScratchCardBag implements Serializable {

    private final static String DEFAULT_TITLE = "稀有卡片";

    private final static String DEFAULT_INNER_TITLE = "刮到多少奖励多少";

    private final static Integer DEFAULT_CARD_COUNT = 6;

    //每日免费赠送的刮刮卡包数量
    public static final int FREE_SCRATCH_BAGS_IN_DAY = 3;

    //每日可免费获取的卡包上限
    public static final int SCRATCH_BAGS_IN_DAY_LIMIT = 9;


    private Long userId;//用户ID
    private String title;//卡包外部显示title
    private String innerTitle;//卡包内显示title
    private Integer cardCount;//卡保内卡片总数
    private Integer scratchedCount;//已刮开的卡片数
    private ScratchBagType bagType;//卡包类型（R,N,SR,SSR...）
    private List<ScratchCard> scratchCards;//包含的卡片列表
    private int bagIndex;//卡包索引
    private Date scratchTime;//全部刮开时间
    private Long moneyTotal;//人民币总奖励
    private Long goldTotal;//金币总奖励


    /**
     * 创建固定数量的卡片列表
     *
     * @param cardCount
     * @return
     */
    private static List<ScratchCard> initScratchCards(int cardCount) {
        List<ScratchCard> scratchCards = Lists.newArrayListWithCapacity(cardCount);
        for (int i = 0; i < cardCount; i++) {
            scratchCards.add(new ScratchCard(i));
        }
        return scratchCards;
    }

    public ScratchCardBag() {
    }

    public ScratchCardBag(Long userId, ScratchBagType bagType, int bagIndex) {
        this(userId, DEFAULT_TITLE, DEFAULT_INNER_TITLE, DEFAULT_CARD_COUNT, 0, bagType, initScratchCards(DEFAULT_CARD_COUNT), bagIndex);
    }

    public ScratchCardBag(Long userId, String title, String innerTitle, Integer cardCount, Integer scratchedCount, ScratchBagType bagType, List<ScratchCard> scratchCards, int bagIndex) {
        this.userId = userId;
        this.title = title;
        this.innerTitle = innerTitle;
        this.cardCount = cardCount;
        this.scratchedCount = scratchedCount;
        this.bagType = bagType;
        this.scratchCards = scratchCards;
        this.bagIndex = bagIndex;
        this.goldTotal = 0L;
        this.moneyTotal = 0L;
    }

    public int getBagIndex() {
        return bagIndex;
    }

    public void setBagIndex(int bagIndex) {
        this.bagIndex = bagIndex;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInnerTitle() {
        return innerTitle;
    }

    public void setInnerTitle(String innerTitle) {
        this.innerTitle = innerTitle;
    }

    public Integer getCardCount() {
        return cardCount;
    }

    public void setCardCount(Integer cardCount) {
        this.cardCount = cardCount;
    }

    public Integer getScratchedCount() {
        return scratchedCount;
    }

    public void setScratchedCount(Integer scratchedCount) {
        this.scratchedCount = scratchedCount;
    }

    public ScratchBagType getBagType() {
        return bagType;
    }

    public void setBagType(ScratchBagType bagType) {
        this.bagType = bagType;
    }

    public List<ScratchCard> getScratchCards() {
        return scratchCards;
    }

    public void setScratchCards(List<ScratchCard> scratchCards) {
        this.scratchCards = scratchCards;
    }

    public Date getScratchTime() {
        return scratchTime;
    }

    public void setScratchTime(Date scratchTime) {
        this.scratchTime = scratchTime;
    }

    public Long getMoneyTotal() {
        return moneyTotal;
    }

    public void setMoneyTotal(Long moneyTotal) {
        this.moneyTotal = moneyTotal;
    }

    public Long getGoldTotal() {
        return goldTotal;
    }

    public void setGoldTotal(Long goldTotal) {
        this.goldTotal = goldTotal;
    }

    /**
     * 卡片
     */
    public static class ScratchCard implements Serializable {
        private Integer index;//卡片在卡包中的位置
        private String title;//卡片title
        private Integer status;//0:未刮奖;1:已刮奖;2:已发奖
        private ScratchCardPrize prize;//卡片奖励

        public ScratchCard() {
        }

        public ScratchCard(Integer index) {
            this(index, "", 0, null);
        }

        public ScratchCard(Integer index, String title, Integer status, ScratchCardPrize prize) {
            this.index = index;
            this.title = title;
            this.status = status;
            this.prize = prize;
        }

        public Integer getIndex() {
            return index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public ScratchCardPrize getPrize() {
            return prize;
        }

        public void setPrize(ScratchCardPrize prize) {
            this.prize = prize;
        }
    }

    /**
     * 卡片奖励
     */
    public static class ScratchCardPrize implements Serializable {
        private ScratchPriceType priceType;//奖励类型
        private Long priceAmount;//奖励数量

        public ScratchPriceType getPriceType() {
            return priceType;
        }

        public void setPriceType(ScratchPriceType priceType) {
            this.priceType = priceType;
        }

        public Long getPriceAmount() {
            return priceAmount;
        }

        public void setPriceAmount(Long priceAmount) {
            this.priceAmount = priceAmount;
        }
    }
}
