package cn.tuia.explore.center.api.dto.qcc.ggk.enums;

import cn.tuia.explore.center.api.dto.qcc.ggk.ScratchCardBag;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Random;

/**
 * @author: sjx
 * @date: 2019-10-17 10:55
 */
public enum ScratchBagType {
    R(0, "R", "", Lists.newArrayList()),
    N(1, "N", "", Lists.newArrayList()),
    SR(2, "SR", "", Lists.newArrayList()),
    SSR(3, "SSR", "", Lists.newArrayList()),
    ;

    private int code;
    private String title;
    private String desc;
    //奖池目前是有顺序的
    private List<PriceSet> pricePool;

    ScratchBagType(int code, String title, String desc, List<PriceSet> pricePool) {
        this.code = code;
        this.title = title;
        this.desc = desc;
        this.pricePool = pricePool;
    }

    public static ScratchBagType getByCode(int code){
        for(ScratchBagType type: ScratchBagType.values() ){
            if(type.code == code){
                return type;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /***
     * 按概率随机中奖逻辑
     * @return
     */
    public PriceSet randomPrice() {
        for (PriceSet p : pricePool) {
            //概率计算逻辑
            Random random = new Random();
            if (random.nextInt(p.getDenominator()) < p.numerator) {
                return p;
            }
        }
        //未中奖
        return null;
    }

    public class PriceSet {
        private ScratchCardBag.ScratchCardPrize prize;//奖励内容
        private int numerator;//概率分子
        private int denominator;//概率分母

        public PriceSet(ScratchCardBag.ScratchCardPrize prize, int numerator, int denominator) {
            this.prize = prize;
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public ScratchCardBag.ScratchCardPrize getPrize() {
            return prize;
        }

        public void setPrize(ScratchCardBag.ScratchCardPrize prize) {
            this.prize = prize;
        }

        public int getNumerator() {
            return numerator;
        }

        public void setNumerator(int numerator) {
            this.numerator = numerator;
        }

        public int getDenominator() {
            return denominator;
        }

        public void setDenominator(int denominator) {
            this.denominator = denominator;
        }
    }
}
