package cn.tuia.explore.center.api.dto.qcc.ggk.enums;


/**
 * @author: sjx
 * @date: 2019-10-17 11:08
 */
public enum ScratchPriceType {
    NOTHING(-1, "未中奖", "未中奖"),
    MONEY(0, "现金", "现金奖品"),
    GOLD(1, "金币", "金币奖励"),
    ;

    ScratchPriceType(int type, String name, String desc) {
        this.type = type;
        this.name = name;
        this.desc = desc;
    }

    private int type;
    private String name;
    private String desc;

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static ScratchPriceType getByCode(int code){
        for (ScratchPriceType value : ScratchPriceType.values()) {
            if(value.type == code){
                return value;
            }
        }
        return null;
    }
}
