package cn.tuia.explore.center.api.dto.req;

import cn.tuia.explore.center.api.enums.AppEnum;

import java.io.Serializable;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: AppBaseReqDto.java , v 0.1 2019-07-08 16:53 ElinZhou Exp $
 */
public class AppBaseReqDto implements Serializable {
    private static final long serialVersionUID = 2581414704273384279L;

    /**
     * 系统版本号
     */
    private long version;

    /**
     * 操作系统：Android,iOS
     */
    private String system;

    /**
     * 渠道号
     */
    private String source;


    /**
     * 接口调用者 0:未知 1:h5 2:原生
     */
    private Integer invoker;

    /**
     * 设备号
     */
    protected String deviceId;

    /**
     * app类型
     */
    protected AppEnum app;

    public AppEnum getApp() {
        return app;
    }

    public void setApp(AppEnum app) {
        this.app = app;
    }

    public long getVersion() {
        return version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getSystem() {
        return system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public Integer getInvoker() {
        return invoker;
    }

    public void setInvoker(Integer invoker) {
        this.invoker = invoker;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}
