package cn.tuia.explore.center.api.dto.req;

import cn.tuia.explore.center.api.dto.rsp.ImageDto;

import java.io.Serializable;
import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostPublishDto.java , v 0.1 2019-05-23 17:02 ElinZhou Exp $
 */
public class PostPublishDto implements Serializable {
    private static final long serialVersionUID = 8127777161934459031L;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 原始url
     */
    private String sourceUrl;

    /**
     * 原始内容来源
     *
     * @see cn.tuia.explore.center.api.enums.PostSourceType
     */
    private Integer sourceType;

    /**
     * 内容类型
     */
    private String contentType;

    /**
     * 标题
     */
    private String postTitle;

    /**
     * 视频地址
     */
    private String videoUrl;

    /**
     * 圈子id，0表示个人圈
     */
    private Integer groupType;

    /**
     * 发布者的评论
     */
    private String publisherComment;

    /**
     * 原文摘要
     */
    private String sourceAbstract;

    /**
     * 图片地址
     */
    private List<String> imageList;

    /**
     * 图片对象
     */
    private List<ImageDto> images;

    /**
     * 帖子的标签id
     */
    private List<Integer> tagIds;

    /**
     * 作者昵称
     */
    private String authorNickname;


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getSourceUrl() {
        return sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getPostTitle() {
        return postTitle;
    }

    public void setPostTitle(String postTitle) {
        this.postTitle = postTitle;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public Integer getGroupType() {
        return groupType;
    }

    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }

    public String getPublisherComment() {
        return publisherComment;
    }

    public void setPublisherComment(String publisherComment) {
        this.publisherComment = publisherComment;
    }

    public String getSourceAbstract() {
        return sourceAbstract;
    }

    public void setSourceAbstract(String sourceAbstract) {
        this.sourceAbstract = sourceAbstract;
    }

    /**
     * @deprecated 使用images字段
     * @return
     */
    @Deprecated
    public List<String> getImageList() {
        return imageList;
    }
    /**
     * @deprecated 使用images字段
     * @return
     */
    @Deprecated
    public void setImageList(List<String> imageList) {
        this.imageList = imageList;
    }

    public List<ImageDto> getImages() {
        return images;
    }

    public void setImages(List<ImageDto> images) {
        this.images = images;
    }

    public List<Integer> getTagIds() {
        return tagIds;
    }

    public void setTagIds(List<Integer> tagIds) {
        this.tagIds = tagIds;
    }

    public String getAuthorNickname() {
        return authorNickname;
    }

    public void setAuthorNickname(String authorNickname) {
        this.authorNickname = authorNickname;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}
