package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 金币支出
 *
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: CoinExpense.java , v 0.1 2019-09-10 17:06 ElinZhou Exp $
 */
public enum CoinExpense implements CoinTradeCode {

    UNKNOW(0, "未知支出"),

    WITHDRAW(1, "申请提现"),

    BUY_SCRATCH_CARD(2, "购买刮刮卡"),

    ;

    CoinExpense(int bizCode, String desc) {
        this.bizCode = bizCode;
        this.desc = desc;
    }

    private int bizCode;

    private String desc;


    private static final Map<Integer, CoinExpense> CACHE =
            Arrays.stream(CoinExpense.values()).collect(Collectors.toMap(CoinExpense::bizCode, c -> c));

    public static CoinExpense of(int bizCode) {
        CoinExpense coinExpense = CACHE.get(bizCode);
        if (coinExpense != null) {
            return coinExpense;
        }
        return UNKNOW;
    }

    @Override
    public int bizCode() {
        return bizCode;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
