package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: DailyLuckyRewardType.java , v 0.1 2019-10-18 10:42 ElinZhou Exp $
 */
public enum DailyLuckyRewardType {


    FIRST_PRIZE(1, 10000),

    SECOND_PRIZE(2, 100),

    THIRD_PRIZE(3, 10),

    NONE(4, 0);
    private int code;

    private long reward;

    private static final Map<Integer, DailyLuckyRewardType> CACHE =
            Arrays.stream(DailyLuckyRewardType.values()).collect(Collectors.toMap(DailyLuckyRewardType::getCode,
                    d -> d));

    public long getReward() {
        return reward;
    }

    public int getCode() {
        return code;
    }


    public static DailyLuckyRewardType of(int code) {
        return CACHE.get(code);
    }

    DailyLuckyRewardType(int code, long reward) {
        this.code = code;
        this.reward = reward;
    }}
