package cn.tuia.explore.center.api.enums;

import cn.tuia.explore.center.api.dto.general.AbstractMessageContent;
import cn.tuia.explore.center.api.dto.general.AttentionMessage;
import cn.tuia.explore.center.api.dto.general.LikeMessage;
import cn.tuia.explore.center.api.dto.general.ReplyCommentMessage;
import cn.tuia.explore.center.api.dto.general.ReplyPostMessage;
import cn.tuia.explore.center.api.dto.general.ReplyRecommendPostMessage;
import cn.tuia.explore.center.api.dto.general.SystemMessage;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: MessageStoreType.java , v 0.1 2019-07-22 16:28 ElinZhou Exp $
 */
public enum MessageStoreType {

    LIKE(1, MessageType.LIKE, LikeMessage.class),

    REPLY_COMMENT(2, MessageType.REPLY_COMMENT, ReplyCommentMessage.class),

    REPLY_POST(3, MessageType.REPLY_POST, ReplyPostMessage.class),

    ATTENTION(4, MessageType.ATTENTION, AttentionMessage.class),

    SYSTEM(5, MessageType.SYSTEM, SystemMessage.class),

    REPLY_RECOMMEND_POST(6, MessageType.GENERAL, ReplyRecommendPostMessage.class),
    ;

    private int code;

    private MessageType type;

    private Class<? extends AbstractMessageContent> clazz;

    private static final Map<Integer, MessageStoreType> CACHE =
            Arrays.stream(MessageStoreType.values()).collect(Collectors.toMap(MessageStoreType::getCode, p -> p));

    public static MessageStoreType of(int code) {
        return CACHE.get(code);
    }

    MessageStoreType(int code, MessageType type, Class<? extends AbstractMessageContent> clazz) {
        this.code = code;
        this.type = type;
        this.clazz = clazz;
    }

    public int getCode() {
        return code;
    }

    public MessageType getType() {
        return type;
    }

    public Class<? extends AbstractMessageContent> getClazz() {
        return clazz;
    }}
