package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.MissionReqDto;
import cn.tuia.explore.center.api.dto.req.AppUserBaseReqDto;

import java.util.Map;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: RemoteMissionService.java , v 0.1 2019-10-09 13:48 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteMissionService {

    /**
     * 触发每日任务
     *
     * @param reqDto
     */
    void triggerDaily(MissionReqDto reqDto);


    /**
     * 领取奖励
     *
     * @param reqDto
     * @throws BizException
     */
    long awardDaily(MissionReqDto reqDto) throws BizException;

    /**
     * 查询任务进度
     *
     * @param reqDto
     * @return
     */
    Map<Integer, Long> queryProgress(AppUserBaseReqDto reqDto);
}
