package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.AppUserBaseReqDto;
import cn.tuia.explore.center.api.dto.req.AppWeakUserBaseReqDto;
import cn.tuia.explore.center.api.dto.req.ReadTaskJoinDto;
import cn.tuia.explore.center.api.dto.req.UserReadReportDto;
import cn.tuia.explore.center.api.dto.rsp.ReadInfoDto;
import cn.tuia.explore.center.api.dto.rsp.ReadTaskDetailDto;
import cn.tuia.explore.center.api.dto.rsp.ReadTaskDto;

import java.util.List;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: RemoteReadTaskService.java , v 0.1 2019-09-19 15:22 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteReadTaskService {

    /**
     * 查询某一天的任务
     *
     * @param reqDto
     * @return
     */
    List<ReadTaskDto> queryTasks(AppWeakUserBaseReqDto reqDto) throws BizException;

    /**
     * 查询用户的阅读信息
     *
     * @param reqDto
     * @return
     */
    ReadInfoDto queryInfo(AppUserBaseReqDto reqDto);

    /**
     * 参与活动
     *
     * @param joinDto
     * @throws BizException
     */
    void join(ReadTaskJoinDto joinDto) throws BizException;

    /**
     * 查询任务详情
     *
     * @param joinDto
     * @return
     * @throws BizException
     */
    ReadTaskDetailDto detail(ReadTaskJoinDto joinDto) throws BizException;


    /**
     * 阅读上报
     *
     * @param reportDto
     * @throws BizException
     */
    ReadInfoDto readReport(UserReadReportDto reportDto) throws BizException;
}
