package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.qcc.ggk.ScratchCardBag;

import java.util.List;

/**
 * @author: Administrator
 * @date: 2019-10-18 16:21
 */
@AdvancedFeignClient
public interface RemoteScratchService {

    /**
     * 查询用户指定日期的卡包记录
     *
     * @param userId  用户ID
     * @param curDate 日期
     * @return
     */
    List<ScratchCardBag> listBagByUser(Long userId, String curDate);

    /**
     * 为用户添加卡包记录
     *
     * @param bag 卡包对象
     * @return
     */
    boolean addBag4user(ScratchCardBag bag);

    /**
     * 获取用户最后四条卡包记录，用户计算下一个卡包的类型
     *
     * @param userId 用户ID
     * @return
     */
    List<ScratchCardBag> lastListBagByUser(Long userId);

    int countByUser(Long userId);

    /**
     * 用户通过金币购买刮刮卡
     *
     * @param userId 用户ID
     * @return
     */
    ScratchCardBag buyCard(Long userId) throws BizException;

    /**
     * 用户刮刮卡结算
     *
     * @param userId 用户ID
     * @param bag    卡包对象
     * @return
     */
    boolean settleCard(Long userId, ScratchCardBag bag) throws BizException;
}
