package cn.tuia.explore.center.api.util;

import cn.tuia.explore.center.api.enums.EPRedisKey;
import com.google.common.base.Joiner;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 跨平台redis key组合工具
 */
public class EPRedisKeyUtil {

    private static final String SEPARATOR = "_";

    private static final String EC_PREFIX = "EP";

    /**
     * 用户每日刮刮卡包数量
     *
     * @param userId    用户ID
     * @param localDate 日期
     * @return
     */
    public static String countScratchCardBag4user(long userId, LocalDate localDate) {
        return getKey(EPRedisKey.K02, userId, localDate.format(DateTimeFormatter.ISO_DATE));
    }

    /**
     * 用户每日刮刮卡包
     *
     * @param userId    用户ID
     * @param localDate 日期
     * @return
     */
    public static String scratchCardBag4user(long userId, LocalDate localDate) {
        return getKey(EPRedisKey.K03, userId, localDate.format(DateTimeFormatter.ISO_DATE));
    }

    private static String getKey(EPRedisKey redisKey, Object... objects) {
        return getKey(EC_PREFIX, redisKey, objects);
    }

    private static String getKey(String prefix, EPRedisKey redisKey, Object... objects) {


        Joiner joiner = Joiner.on(SEPARATOR).skipNulls();
        List<Object> items = new ArrayList<>();
        items.add(prefix);
        items.add(redisKey);
        items.addAll(Arrays.stream(objects).map(value -> value == null ? "null" : value).collect(Collectors.toList()));
        return joiner.join(items);

    }

    private EPRedisKeyUtil() {
        // 不允许创建实例
    }


}
