package cn.tuia.explore.center.constant;

import com.google.common.collect.Lists;

import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: GlobalConstant.java , v 0.1 2019-05-17 11:06 ElinZhou Exp $
 */
@SuppressWarnings("squid:S2386")
public class GlobalConstant {

    private GlobalConstant() {
        //private
    }

    /**
     * 批量获取id的数量
     */
    public static final int BATCH_ID_MAKER_SIZE = 1000;

    /**
     * 默认编码
     */
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();

    /**
     * 默认头像
     */
    public static final String DEFAULT_HEAD_IMAGE = "https://yun.tuia.cn/ttnews-media/img/iscgzjjzzg.png";


    /**
     * 帖子进入推荐列表的阈值
     */
    public static final int POST_LEVEL_UP_TIMES = 5;


    /**
     * 自动发布时的文案
     */
    public static final List<String> AUTO_PUBLISH_COMMENTS = Lists.newArrayList("转发了",
            "推荐了",
            "有点意思",
            "你们也看看",
            "不看就亏了",
            "不看会后悔",
            "这个写的好",
            "推荐给你们",
            "推荐给朋友们",
            "也许你们需要",
            "推荐你一起来看😊",
            "写的蛮有意思的",
            "我觉得很有意思",
            "很喜欢这条内容",
            "邀请你来一起围观",
            "希望大家也多多分享",
            "刚看过就顺手转发了",
            "要是再多讲点就好了",
            "好看的东西当然要分享",
            "好东西要分享给朋友们",
            "我觉得这个内容很好看",
            "希望伙伴们喜欢我的分享",
            "每天都能看到很多新知识",
            "没什么比分享快乐更重要",
            "这是一篇不容错过的文章",
            "看的越多越觉得自己懂得少");

    /**
     * 动态默认分
     */
    public static final double DEFAULT_POST_SCORE = 3;

    /**
     * 帖子得分上限
     */
    public static final int POST_MAX_SCORE = 10;

    /**
     * 每次推荐的召回列表数量
     */
    public static final int SINGLE_RECOMMEND_PAGE_SIZE = 500;

    /**
     * 默认的时间格式
     */
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FOMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    /**
     * 特殊手机号
     */
    public static final String SPECIAL_PHONE_NUMBER = "13888888888";

    /**
     * 特殊手机号验证码
     */
    public static final String SPECIAL_PHONE_VERIFI_CODE = "8888";

    /**
     * 测试环境排除缓存el表达式
     */
    public static final String TEST_ENV_EXCLUDE_EX = "!T(cn.com.duiba.boot.utils.SpringEnvironmentUtils).isTestEnv()";


    /**
     * 起始值，小于这个值轮空
     */
    public static final long DAILY_LUCKY_START_DECIAML = 328088L;

    public static final int DAILY_LUCKY_MAX_NUMBER = 32;

    /**
     * 中奖码最大十进制数(不包括)
     */
    public static final long DAILY_LUCKY_MAX_DECIMAL = (long) Math.pow((double) DAILY_LUCKY_MAX_NUMBER + 1D, 4);
}
