package cn.tuia.explore.center.entity;

import java.util.Map;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PureContent.java , v 0.1 2019-05-21 16:27 ElinZhou Exp $
 */
public class PureContent {


    /**
     * 接受者的id
     */
    private String clientId;
    /**
     * @see cn.tuia.explore.center.enums.PushType
     */
    private String type;

    private String title;

    private String desc;

    /**
     * 消息内容是否是可变的，如果不可变，则通过contentGroup字段进行分组推送
     */
    private boolean mutable;

    private String contentGroup;

    /**
     * 安卓跳转地址
     */
    private String androidJump;

    /**
     * 重试次数
     */
    private int retryTimes = 0;

    private String appId;

    private Map<String, String> extra;

    @Override
    public int hashCode() {
        if (!mutable) {
            //如果是不可变对象，则根据contentGroup来区分对象
            return contentGroup.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PureContent)) {
            return false;
        }
        PureContent other = (PureContent) obj;
        if (other.isMutable() || this.isMutable()) {
            //如果比较的两个对象任意一个是可变的，就返回equals方法结果
            return super.equals(other);
        }
        return this.contentGroup.equals(other.contentGroup);
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public int retry() {
        return retryTimes++;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isMutable() {
        return mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public String getContentGroup() {
        return contentGroup;
    }

    public void setContentGroup(String contentGroup) {
        this.contentGroup = contentGroup;
    }

    public Map<String, String> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getAndroidJump() {
        return androidJump;
    }

    public void setAndroidJump(String androidJump) {
        this.androidJump = androidJump;
    }

    public int getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }
}
