package cn.tuia.explore.center.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PushType.java , v 0.1 2019-05-21 14:41 ElinZhou Exp $
 */
public enum PushType {


    /**
     * 透传通知
     */
    THROUGH_NOTIFICATION("0"),

    /**
     * 通知
     */
    NOTIFICATION("1"),

    /**
     * 通知&透传通知
     */
    BOTH_NOTIFICATION("2"),

    /**
     * 透传数据
     */
    THROUGH_DATA("3"),

    ;

    private static final Map<String, PushType> CACHE =
            Arrays.stream(PushType.values()).collect(Collectors.toMap(PushType::getCode, p -> p));
    PushType(String code) {
        this.code = code;
    }

    private String code;

    public String getCode() {
        return code;
    }

    public static PushType of(String code) {
        return CACHE.get(code);
    }

}
