package cn.tuia.explore.center.enums;

/**
 * @author ElinZhou
 * @version $Id: RecordType.java , v 0.1 2019-06-18 16:06 ElinZhou Exp $
 */
public enum RecordType {


    /**
     * 曝光记录
     */
    EXPOSURE(3 * 24, 1),

    /**
     * 话题曝光记录
     */
    DISCUSS_EXPOSURE(180 * 24, 2),

    /**
     * 热闻已推荐记录
     */
    HOT_NEWS(7 * 24, 3),

    /**
     * 用户动态分享记录
     */
    POST_SHARE(180 * 24, 4),

    /**
     * 用户动态评论增加成就记录
     */
    POST_COMMENT_ACHIEVEMENT(180 * 24, 4),

    ;

    RecordType(int expireHour, int type) {
        this.expireHour = expireHour;
        this.type = type;
    }

    /**
     * 失效日期
     */
    private int expireHour;

    private int type;

    public int getExpireHour() {
        return expireHour;
    }

    public int getType() {
        return type;
    }}
