package cn.tuia.explore.center.enums;

/**
 * @author ElinZhou
 * @version $Id: RedisKey.java , v 0.1 2017/5/19 下午4:38 ElinZhou Exp $
 */
public enum RedisKey {

    /**
     *token与userid的映射
     */
    K01,

    /**
     * 消息推送分布式锁
     */
    K02,

    /**
     * 待推送消息
     */
    K03,
    /**
     * 某条记录的点赞数
     */
    K04,
    /**
     * 某篇帖子的评论数
     */
    K05,
    /**
     * 某篇帖子的分享数
     */
    K06,
    /**
     * 待同步点赞数的记录
     */
    K07,
    /**
     * 待同步评论数的记录
     */
    K08,
    /**
     * 待同步分享数的记录
     */
    K09,
    /**
     * 某业务技术器
     */
    K10,
    /**
     * 待同步的计数器数据
     */
    K11,
    /**
     * 访问主页分布式锁
     */
    K12,

    /**
     * 子评论列表
     */
    K13,
    /**
     * 待同步的评论
     */
    K14,
    /**
     * 用户推荐列表排序缓存
     */
    K15,

    /**
     * 短信验证码
     */
    K17,

    /**
     * 更新record表时的分布式锁
     */
    K19,

    /**
     * 动态的实时得分
     */
    K20,

    /**
     * 动态曝光时记录，用来与后续点击进行匹配
     */
    K21,

    /**
     * 进入动态时记录，用户与后续退出动态进行匹配
     */
    K22,

    /**
     * 退出动态时记录，用来防止多次退出计数
     */
    K23,

    /**
     * 待推荐的内容id列表缓存
     */
    K24,

    /**
     * 得分清零分布式锁
     */
    K25,
    /**
     * 每秒钟待推送的数据
     */
    K26,

    /**
     * 内容的曝光数
     */
    K27,

    /**
     * 内容的点击数
     */
    K28,

    /**
     * 频道内容列表缓存
     */
    K30,

    /**
     * 用户未读消息提醒
     */
    K32,

    /**
     * 用户上一次点击该标签动态的时间
     */
    K33,

    /**
     * 用户的开始/结束阅读记录
     */
    K37,

    /**
     * 老用户内容引导消息
     */
    K38,

    /**
     * 用户观看视频开始时间
     */
    K39,

    /**
     * 记录今日是否创建过阅读任务
     */
    K40,

    /**
     * 加入阅读任务分布式锁
     */
    K43,

    /**
     * 一元提现每日限制
     */
    K44,

    /**
     * 每日任务的进度
     */
    K45,

    /**
     * 每日必抢中奖码生成锁
     */
    K47,

    ;

}
