package cn.tuia.explore.center.util;

import cn.tuia.explore.center.entity.RecommendRecord;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;

import static com.alibaba.fastjson.JSON.toJSONString;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: BaseInnerLog.java , v 0.1 2017/7/20 下午4:49 ZhouFeng Exp $
 */
public class BaseInnerLog {

    private static final Logger LOGGER = LoggerFactory.getLogger(BaseInnerLog.class);

    /**
     * 探索版统一日志分组
     */
    private static final String EXPLORE_INNER_LOG_GROUP = "12";

    private static final String POST_RECOMMEND_LOG = "5";

    private static final String DATE_FORMATTER = "yyyy-MM-dd HH:mm:ss";

    public static void postRecommendLog(RecommendRecord recommendRecord) {
        log(JSON.toJSONString(recommendRecord), POST_RECOMMEND_LOG, EXPLORE_INNER_LOG_GROUP);
    }

    private static void log(String json, String type, String group) {
        if (StringUtils.isNotEmpty(json)) {

            BaseInnerRuleDto ruleDto = new BaseInnerRuleDto();
            ruleDto.setGroup(group);
            ruleDto.setJson(json.replace("\\n", ""));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMATTER);
            ruleDto.setTime(simpleDateFormat.format(new Date()));
            ruleDto.setType(type);
            String jsonString = toJSONString(ruleDto);
            LOGGER.info("{}", jsonString);

        }
    }

    private BaseInnerLog() {
        // 不可实例化类
    }
}
