package cn.tuia.explore.center.util;

import cn.tuia.explore.center.constant.WechatPayConstant;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;
import org.springframework.core.io.ClassPathResource;

import javax.net.ssl.SSLContext;
import java.io.InputStream;
import java.security.KeyStore;

/**
 * 加载证书的类
 *
 * @author
 * @since 2017/08/16
 */

@SuppressWarnings({"squid:S00112", "squid:CallToDeprecatedMethod"})
public class CertUtil {

    private CertUtil() {
        throw new UnsupportedOperationException();
    }

    /**
     * 加载证书
     */
    public static SSLConnectionSocketFactory initCert() throws Exception {
        InputStream instream;
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        //证书地址
        instream = new ClassPathResource(WechatPayConstant.CETIFICATE_PATH).getInputStream();
        keyStore.load(instream, WechatPayConstant.MCHID.toCharArray());

        if (null != instream) {
            instream.close();
        }

        SSLContext sslcontext =
                SSLContexts.custom().loadKeyMaterial(keyStore, WechatPayConstant.MCHID.toCharArray()).build();
        return new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null,
                SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

}

