package cn.tuia.explore.center.util;

import cn.tuia.explore.center.entity.ChineseDay;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: ChineseCalendar.java , v 0.1 2019-07-15 09:39 ElinZhou Exp $
 */
public class ChineseCalendar {

    private static volatile ChineseCalendar chineseCalendar;

    private Map<LocalDate, ChineseDay> mapper = new HashMap<>();


    private ChineseCalendar(String data) {

        Splitter splitter = Splitter.on(".").trimResults().omitEmptyStrings();
        Joiner joiner = Joiner.on(" ");
        JSONArray jsonArray = JSON.parseArray(data);
        for (Object o : jsonArray) {
            JSONObject jsonObject = (JSONObject) o;
            for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {

                LocalDate date = LocalDate.parse(entry.getKey(), DateTimeFormatter.ISO_DATE);
                ChineseDay chineseDay = ((JSONObject) entry.getValue()).toJavaObject(ChineseDay.class);
                if (StringUtils.isNotEmpty(chineseDay.getAvoid())) {
                    chineseDay.setAvoid(joiner.join(splitter.splitToList(chineseDay.getAvoid()).stream().limit(2).collect(Collectors.toList())));
                }
                if (StringUtils.isNotEmpty(chineseDay.getSuit())) {
                    chineseDay.setSuit(joiner.join(splitter.splitToList(chineseDay.getSuit()).stream().limit(2).collect(Collectors.toList())));
                }
                mapper.put(date, chineseDay);
            }
        }
    }

    public static ChineseCalendar newInstance(String data) {
        if (chineseCalendar == null) {
            synchronized (ChineseCalendar.class) {
                if (chineseCalendar == null) {
                    chineseCalendar = new ChineseCalendar(data);
                }
            }
        }
        return chineseCalendar;
    }

    public ChineseDay get(LocalDate date) {
        return mapper.get(date);
    }


}
