package cn.tuia.explore.center.util;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: DateUtil.java , v 0.1 2018/2/5 上午11:50 ZhouFeng Exp $
 */
public class DateUtil {

    private DateUtil() {
        //private
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    /**
     * 时间文案描述
     *
     * @param time
     * @return
     */
    public static String timeDesc(Date time) {
        //计算时间差(秒)
        long duration = Duration.between(toLocalDateTime(time), LocalDateTime.now()).getSeconds();
        if (duration < 60) {
            return "刚刚";
        } else if (duration < 60 * 60) {
            return String.format("%s分钟前", duration / 60);
        } else if (duration < 60 * 60 * 24) {
            return String.format("%s小时前", duration / 60 / 60);
        } else if (duration < 60 * 60 * 24 * 31) {
            return String.format("%s天前", duration / 60 / 60 / 24);
        } else if (duration < 60 * 60 * 24 * 365) {
            return String.format("%s个月前", duration / 60 / 60 / 24 / 31);
        } else {
            return "很久前";
        }
    }


}
