package cn.tuia.explore.center.util;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: DeflateUtil.java , v 0.1 2019-06-18 18:25 ElinZhou Exp $
 */
public class DeflateUtil {

    private static final String TAG_CODE = "DEFLATEDATA-";

    private DeflateUtil() {
        throw new UnsupportedOperationException();
    }


    public static boolean isDeflateData(String data) {
        return data.startsWith(TAG_CODE);
    }


    /**
     * @param data 待解压缩的
     * @return 解压缩后
     * @throws IOException
     */
    public static String uncompress(String data) throws IOException {
        if (StringUtils.isBlank(data)) {
            return "";
        }
        if (!isDeflateData(data)) {
            return data;
        }
        data = data.substring(TAG_CODE.length());
        byte[] inputByte = Base64.decodeBase64(data);
        int len = 0;
        Inflater infl = new Inflater();
        infl.setInput(inputByte);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] outByte = new byte[1024];
        try {
            while (!infl.finished()) {
                // 解压缩并将解压缩后的内容输出到字节输出流bos中
                len = infl.inflate(outByte);
                if (len == 0) {
                    break;
                }
                bos.write(outByte, 0, len);
            }
            infl.end();
        } catch (Exception e) {
            //
        } finally {
            bos.close();
        }
        return bos.toString();
    }

    /**
     * 压缩.
     *
     * @param data 待压缩
     * @return 压缩后的数据
     * @throws IOException
     */
    public static String compress(String data) throws IOException {
        byte[] inputByte = data.getBytes();
        int len;
        Deflater defl = new Deflater();
        defl.setLevel(4);
        defl.setInput(inputByte);
        defl.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] outputByte = new byte[1024];
        try {
            while (!defl.finished()) {
                // 压缩并将压缩后的内容输出到字节输出流bos中
                len = defl.deflate(outputByte);
                bos.write(outputByte, 0, len);
            }
            defl.end();
        } finally {
            bos.close();
        }
        return TAG_CODE + Base64.encodeBase64String(bos.toByteArray());
    }
}
