package cn.tuia.explore.center.util;

import org.apache.commons.lang3.StringUtils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: GzipUtil.java , v 0.1 2019-01-14 16:29 ElinZhou Exp $
 */
public class GzipUtil {

    private static final String TAG_CODE = "GZIPDATA-";

    private GzipUtil() {
        throw new UnsupportedOperationException();
    }


    public static String zip(String data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(data.getBytes());
        gzip.close();
        // 加密后的字符串
        return TAG_CODE + out.toString(StandardCharsets.ISO_8859_1.name());
    }


    public static String unzip(String data) throws IOException {
        if (StringUtils.isBlank(data)) {
            return "";
        }
        if (!isGzipData(data)) {
            return data;
        }
        data = data.substring(TAG_CODE.length());
        ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes(StandardCharsets.ISO_8859_1));
        GZIPInputStream gzipInputStream = new GZIPInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int n;
        while ((n = gzipInputStream.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toString();
    }

    public static boolean isGzipData(String data) {
        return data.startsWith(TAG_CODE);
    }


}
