package cn.tuia.explore.center.util;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RetryUtil.java , v 0.1 2019-05-23 19:20 ElinZhou Exp $
 */
public class RetryUtil {

    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryUtil.class);

    private RetryUtil() {
        //private
    }


    public static boolean retry(BooleanSupplier supplier, int times) {
        return retry(supplier, times, TimeUnit.MILLISECONDS, 50);
    }

    public static boolean retry(BooleanSupplier supplier, int times, TimeUnit timeUnit, int unit) {
        try {
            DBTimeProfile.enter("retry");
            int total = times;
            boolean success = false;
            while (times > 0) {
                try {
                    success = supplier.getAsBoolean();
                } catch (Exception e) {
                    LOGGER.error("业务出错，进行第{}次重试", (total - times + 1), e);
                }
                if (success) {
                    break;
                }
                times--;
                try {
                    timeUnit.sleep(unit);
                } catch (InterruptedException e) {
                    LOGGER.error("业务重试中被中断", e);
                    Thread.currentThread().interrupt();
                }
            }
            return success;
        } finally {
            DBTimeProfile.release();
        }

    }

}
