package cn.tuia.explore.center.util;

import cn.tuia.explore.center.constant.GlobalConstant;
import cn.tuia.explore.center.constant.WechatPayConstant;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;


/**
 * 签名工具
 */
@SuppressWarnings("squid:S00112")
public class SignTool {

    /**
     * 验签方法
     *
     * @param params
     * @return
     */

    public static boolean signVerify(String appSecret, Map<String, String> params) {
        Map<String, String> map = new TreeMap<>();
        map.put("appSecret", appSecret);

        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!entry.getKey().equals("sign")) {
                map.put(entry.getKey(), entry.getValue());
            }
        }

        String sign = sign(map);
        return sign.equals(params.get("sign"));
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null)
            return "";
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    /**
     * 签名方法
     *
     * @param params
     * @return
     */
    public static String sign(Map<String, String> params) {
        List<String> keys = new ArrayList<>(params.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String s : keys) {
            sb.append(params.get(s));
        }
        String sign;
        try {
            sign = toHexValue(encryptMD5(sb.toString().getBytes(GlobalConstant.DEFAULT_ENCODING)));
        } catch (Exception e) {
            throw new RuntimeException("md5 error", e);
        }
        return sign;
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }


    /**
     * 微信支付签名
     *
     * @param characterEncoding 编码格式 utf-8
     */
    public static String wechatPaySign(String characterEncoding, SortedMap<Object, Object> parameters) {
        StringBuilder sb = new StringBuilder();
        Set es = parameters.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            String k = (String) entry.getKey();
            Object v = entry.getValue();
            if (null != v && !"".equals(v)
                    && !"sign".equals(k) && !"key".equals(k)) {
                sb.append(k).append("=").append(v).append("&");
            }
        }
        //获取商务号设置的api秘钥。
        sb.append("key=" + WechatPayConstant.APIKEY);
        String sign;
        try {
            sign = toHexValue(encryptMD5(sb.toString().getBytes(Charset.forName(characterEncoding)))).toUpperCase();
        } catch (Exception e) {
            throw new RuntimeException("md5 error", e);
        }
        return sign;
    }

    public static void main(String[] args) {
        String appKey = "key";
        String appSecret = "secret";

        Map<String, String> params = new TreeMap<>();
        params.put("appKey", appKey);
        params.put("appSecret", appSecret);
        params.put("date", String.valueOf(new Date().getTime()));

        String sign = sign(params);

        params.put("sign", sign);

        Map<String, String> params4pdd = new TreeMap<>();
        params4pdd.put("access_token", "asd78172s8ds9a921j9qqwda12312w1w21211");
        params4pdd.put("client_id", "1");
        params4pdd.put("data_type", "XML");
        params4pdd.put("order_status", "1");
        params4pdd.put("page", "1");
        params4pdd.put("page_size", "10");
        params4pdd.put("timestamp", "1480411125");
        params4pdd.put("type", "pdd.order.number.list.get");
    }
}
