package cn.tuia.explore.center.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import org.apache.commons.lang3.StringUtils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AppInterceptor.java , v 0.1 2018/1/7 上午1:26 ZhouFeng Exp $
 */
public class VersionUtil {

    public static final String FIRST_CODE = "0.0.0.0.0";

    public static final String LAST_CODE = "255.255.255.255.255";

    public static final long FIRST_NUMBER = 0L;

    public static final long LAST_NUMBER = 1099511627775L;

    private VersionUtil() {
        throw new UnsupportedOperationException("不可实例化的类");
    }


    public static Long toVersionNumber(String code) {

        if (StringUtils.isBlank(code)) {
            throw new IllegalArgumentException("版本号为空");
        }

        AtomicInteger bit = new AtomicInteger(32);

        return Splitter.on(".").omitEmptyStrings().trimResults().splitToList(code).stream().mapToLong
                (Long::parseLong).reduce(0, (a, b) -> a | (b << bit.getAndAdd(-8)));

    }

    public static String toVersionCode(Long num) {

        if (num == null) {
            throw new IllegalArgumentException("版本号不能为空");
        }
        return Joiner.on(".").join(Stream.iterate(40, bit -> bit - 8).limit(5).map(bit -> (((long) Math.pow(2, bit)
                - 1) & num) >> bit - 8).map(String::valueOf).collect(Collectors.toList()));
    }

    public static int compare(String version1, String version2) {
        if (toVersionNumber(version1) > toVersionNumber(version2)) {
            return 1;
        } else if (toVersionNumber(version1) < toVersionNumber(version2)) {
            return -1;
        } else {
            return 0;
        }
    }

    /**
     * 左含右不含
     *
     * @param version
     * @param smaller
     * @param bigger
     * @return
     */
    public static Boolean between(String version, String smaller, String bigger) {
        return compare(version, smaller) >= 0 && compare(version, bigger) < 0;
    }

}
