package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static cn.tuia.payment.api.enums.RefundStatusEnum.REFUND_SUCCESS;
import static cn.tuia.payment.api.enums.RefundStatusEnum.refundWarnStatus;

/**
 * @author y.zhao
 * @title: ComplaintRefundStatusEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.07 11:53
 */
@Getter
@AllArgsConstructor
public enum ComplaintRefundStatusEnum {

    NO_REFUND(0, RefundStatusEnum.successRefundStatus, "未退款"),
    SUCCESS(1, Arrays.asList(REFUND_SUCCESS.getCode()), "退款成功"),
    ING(2, RefundStatusEnum.processRefundStatus, "退款中"),
    FAIL(3, refundWarnStatus, "退款失败"),
    ;

    private final Integer code;
    private final List<Integer> refundStatusCode;
    private final String desc;

    public static String getDesc(Integer code) {
        for (ComplaintRefundStatusEnum value : ComplaintRefundStatusEnum.values()) {
            if (value.getRefundStatusCode().contains(code)) {
                return value.getDesc();
            }
        }
        return null;
    }

    public static List<Integer> getRefundStatus(Integer code) {
        for (ComplaintRefundStatusEnum value : ComplaintRefundStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value.getRefundStatusCode();
            }
        }
        return new ArrayList<>();
    }
}
