package cn.tuia.payment.api.constants;


import cn.tuia.payment.api.enums.PaymentChannelEnum;
import lombok.Data;

import java.util.Objects;

/**
 * @author lizhiheng
 */
@Data
public class SomeConstants {
    public static final String LD_RELEASING_NUM_CONFIG = "%s_ld_releasing_num_config";
    public static final String LD_RELEASING_NUM_CONFIG_V2 = "%s_ld_releasing_num_config_v2";
    public static final String LD_REMAINING_NUM_CONFIG = "%s_ld_remaining_num_config";
    public static final String LD_PULL_UP_RATE_CONFIG = "%s_ld_pull_up_rate_config";
    public static final String LD_RELEASING_UPDATE_CONFIG = "ld_releasing_update_config";

    public static final String UP_RELEASING_NUM_CONFIG = "%s_up_releasing_num_config";
    public static final String UP_RELEASING_NUM_CONFIG_V2 = "%s_up_releasing_num_config_v2";
    public static final String UP_REMAINING_NUM_CONFIG = "%s_up_remaining_num_config";
    public static final String UP_PULL_UP_RATE_CONFIG = "%s_up_pull_up_rate_config";
    public static final String UP_RELEASING_UPDATE_CONFIG = "up_releasing_update_config";

    public static final String POOL_TIME_PERIOD_CONFIG = "%s_pool_time_period_config";
    public static final String POOL_RELEASING_UPDATE_CONFIG = "%s_pool_releasing_update_config";

    /**
     * 商户池 时间段 配置
     *
     * @param poolId
     * @return
     */
    public static String getPoolTimePeriodConfig(Long poolId) {
        return String.format(POOL_TIME_PERIOD_CONFIG, poolId);
    }

    /**
     * 商户池 在投池自动更新 配置
     *
     * @param poolId
     * @return
     */
    public static String getPoolReleasingUpdateConfig(Integer channel, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return Objects.equals(channel, PaymentChannelEnum.LIANDONG.getCode()) ? LD_RELEASING_UPDATE_CONFIG :
                    Objects.equals(channel, PaymentChannelEnum.UNION_PAY.getCode()) ? UP_RELEASING_UPDATE_CONFIG :
                            null;
        }
        return String.format(POOL_RELEASING_UPDATE_CONFIG, poolId);
    }

    public static String getLdReleasingNumConfig(String merId) {
        return String.format(LD_RELEASING_NUM_CONFIG, merId);
    }


    public static String getLdReleasingNumConfigV2(String merId, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return String.format(LD_RELEASING_NUM_CONFIG_V2, merId);
        } else {
            return getPoolTimePeriodConfig(poolId);
        }
    }

    public static String getLdPullUpRateConfig(String merId) {
        return String.format(LD_PULL_UP_RATE_CONFIG, merId);
    }

    public static String getLdRemainingNumConfig(String merId) {
        return String.format(LD_REMAINING_NUM_CONFIG, merId);
    }

    public static String getUpReleasingNumConfigV2(String merId, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return String.format(UP_RELEASING_NUM_CONFIG_V2, merId);
        } else {
            return getPoolTimePeriodConfig(poolId);
        }
    }

    public static String getUpPullUpRateConfig(String merId) {
        return String.format(UP_PULL_UP_RATE_CONFIG, merId);
    }

    public static String getUpRemainingNumConfig(String merId) {
        return String.format(UP_REMAINING_NUM_CONFIG, merId);
    }
}