package cn.tuia.payment.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author y.zhao
 * @title: TimePeriodConfigDTO
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.20 14:26
 */
@Data
public class TimePeriodConfigDTO implements Serializable {
    private static final long serialVersionUID = 6271503529052839964L;

    /**
     * tab code
     */
    private Integer tabCode;

    /**
     * tab 描述
     */
    private String tabDesc;

    /**
     * 配置列表
     */
    private List<TimePeriodConfigItemDTO> list;

    @Data
    public static class TimePeriodConfigItemDTO implements Serializable {
        private static final long serialVersionUID = -1570861080195275743L;
        /**
         * 时段
         */
        private Integer timePeriod;

        /**
         * 待投子商户开启数量阈值
         */
        private Integer reReleasingOnNum;

        /**
         * 在投商户数量
         */
        private Integer releasingNum;

        /**
         * 开始时间(HH)
         */
        private Integer startTime;

        /**
         * 结束时间(HH)
         */
        private Integer endTime;
    }
}
