package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum IndustryEnums {

    SHOR_VIDEO(1, "短剧"),

    MEMBER_SHIP_CARD(2, "会籍卡"),

    ACT_4_PAY_RATE(3, "红包活动"),

    ;

    public static List<IndustryEnums> UP_INDUSTRY = Arrays.asList(SHOR_VIDEO, MEMBER_SHIP_CARD);

    public static String convert2Name(Integer code) {
        for (IndustryEnums industryEnums : IndustryEnums.values()) {
            if (industryEnums.getCode().equals(code)) {
                return industryEnums.getDesc();
            }
        }
        return "";
    }

    public static Integer convert2Code(String name) {
        for (IndustryEnums industryEnums : IndustryEnums.values()) {
            if (industryEnums.getDesc().equals(name)) {
                return industryEnums.getCode();
            }
        }
        return 0;
    }

    private final Integer code;
    private final String desc;

    public static boolean isValid(Integer industry) {
        for (IndustryEnums value : IndustryEnums.values()) {
            if (value.getCode().equals(industry)) {
                return true;
            }
        }
        return false;
    }
}

















