package cn.tuia.payment.api.dto.req.up;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhiheng
 */
@Data
public class UpBankMerQuery implements Serializable {

    private static final long serialVersionUID = 7927805444743724284L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 主商户id，和tb_pay_order表的merchant_no是一个字段
     */
    private Integer industry;

    /**
     * 子商户id（二级商户id），和tb_pay_order的bank_merchant_no是一个字段
     */
    private String bankMerId;

    /**
     * 分组，联动的分组
     */
    private String liandongGroup;

    /**
     * 使用时段，运营维护，一天分为4个时段，1，2，3，4
     */
    private Integer timePeriod;

    /**
     * 告警状态
     */
    private Integer warningStatus;

    /**
     * 联动同步过来的状态，启用、关闭、禁用
     */
    private Integer upStatus;

    /**
     * 人工操作的状态，启用、关闭、禁用
     */
    private Integer tuiaStatus;

    /**
     * 投放状态，待投、在投、下线、未知
     */
    private Integer releaseStatus;

    /**
     * 最近编辑人
     */
    private String lastAdminId;

    /**
     * 商户池id
     */
    private Long poolId;

    /**
     * 主体
     */
    private String mainBody;

    /**
     * 备注
     */
    private String remark;
}
