package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum PayWayEnum {
    ALIPAY(1, "支付宝"),
    WECHAT_PAY(2, "微信支付"),
    WECHAT_CLOUD_PAY(3, "微信云闪付"),
    ALIPAY_QR_PAY(4, "支付宝扫码支付");

    private final Integer code;
    private final String name;

    // 根据值获取枚举实例的静态方法
    public static PayWayEnum fromValue(int value) {
        for (PayWayEnum method : PayWayEnum.values()) {
            if (method.getCode() == value) {
                return method;
            }
        }
        throw new IllegalArgumentException("未知的支付方式值: " + value);
    }

    public static String convert2Name(Integer code) {
        for (PayWayEnum payWayEnum : PayWayEnum.values()) {
            if (payWayEnum.getCode().equals(code)) {
                return payWayEnum.getName();
            }
        }
        return "";
    }
}
