/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    private static final String DATE_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";

    public static Date stringToDate(String dateString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_DEFAULT);
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getDataNow() {
        long timestamp = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_DEFAULT, Locale.ENGLISH);
        return sdf.format(new Date(timestamp));
    }

    public static Date getTodayStart() {
        LocalDateTime todayStart = LocalDateTime.of(LocalDateTime.now().toLocalDate(), LocalTime.MIDNIGHT);
        return Date.from(todayStart.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date[] getPreviousHourRange() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime startOfCurrentHour = now.withMinute(0).withSecond(0).withNano(0);
        LocalDateTime startOfPreviousHour = startOfCurrentHour.minusHours(1L);
        Date start = Date.from(startOfPreviousHour.atZone(ZoneId.systemDefault()).toInstant());
        Date end = Date.from(startOfCurrentHour.atZone(ZoneId.systemDefault()).toInstant());
        return new Date[]{start, end};
    }

    public static String getData() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    public static Date getTomorrowStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static void main(String[] args) {
        Date todayStart = DateUtils.getTodayStart();
        System.out.println("\u4eca\u5929\u7684 00:00:00: " + todayStart);
        Date[] previousHourRange = DateUtils.getPreviousHourRange();
        System.out.println("\u4e0a\u4e00\u4e2a\u5c0f\u65f6\u65f6\u95f4\u8303\u56f4: " + previousHourRange[0] + " \u5230 " + previousHourRange[1]);
    }
}

