package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;


/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum BankMerTimePeriodEnums {
    OTHER(0, "未配置"),
    ONE(1, "0-6"),
    TWO(2, "6-12"),
    THREE(3, "12-18"),
    FOUR(4, "18-24"),
    ;
    private final Integer code;
    private final String msg;

    public static final List<Integer> VALID_LIST = Arrays.asList(ONE.getCode(),
                                                                  TWO.getCode(),
                                                                  THREE.getCode(),
                                                                  FOUR.getCode());

    public static boolean isValid(Integer code) {
        return code != null && VALID_LIST.contains(code);
    }

}
