package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum BankMerBatchUpdateTaskItemStatusEnums {

    INIT(0, "初始化"),
    SUCCESS(1, "成功"),
    FAILED(2, "失败"),
    OTHER(-1, "未知或者其他"),
    ;

    private final Integer code;
    private final String msg;

    public static String getMsgByCode(Integer code) {
        for (BankMerBatchUpdateTaskItemStatusEnums item : BankMerBatchUpdateTaskItemStatusEnums.values()) {
            if (item.getCode().equals(code)) {
                return item.getMsg();
            }
        }
        return OTHER.getMsg();
    }
}
