package cn.tuia.payment.api.enums.ali;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: AlipayIdentityType
 * @projectName tuia-payment
 * @description: 支付宝的会员ID: ALIPAY_USER_ID
 * 支付宝登录号: ALIPAY_LOGON_ID
 * 支付宝openid: ALIPAY_OPEN_ID
 * @date 2024.07.04 16:42
 */
@Getter
@AllArgsConstructor
public enum AlipayIdentityTypeEnum {

    ALIPAY_USER_ID("ALIPAY_USER_ID", "支付宝的会员ID"),
    ALIPAY_LOGON_ID("ALIPAY_LOGON_ID", "支付宝登录号"),
    ALIPAY_OPEN_ID("ALIPAY_OPEN_ID", "支付宝openid"),
    ;

    private final String code;
    private final String msg;
}
