package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.req.up.UpBankMerQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.dto.up.UpBankMerDTO;
import cn.tuia.payment.api.entity.UpBankMerEntity;

import java.util.List;
import java.util.Set;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteUpBankMerService {

    UpBankMerEntity getById(Long id);

    /**
     * 根据商户号 获取 商户信息
     *
     * @param mid
     * @return
     */
    List<UpBankMerEntity> getByBankMerId(String mid);

    ResultPage<UpBankMerDTO> page(ReqPageQuery<UpBankMerQuery> query);

    List<UpBankMerDTO> list(ReqPageQuery<UpBankMerQuery> query);

    boolean updateOrSaveBankMer(UpBankMerEntity newOne);

    /**
     * 编辑单个,简单更新（无其他业务逻辑）用这个，带逻辑的请用updateOrSaveBankMer
     */
    boolean updateById(UpBankMerEntity bankMer);

    Set<String> membersFromThePool(String merId, Integer timePeriod);

    List<UpBankMerEntity> getRandomListByTimePeriodAndReleasingStatus(String industry, Integer timePeriod, Integer releasingStatus, Integer num, Integer onOff, Long poolId);
}
